//: c11:Worm.java
// Demonstrates object serialization.
// From 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. See copyright notice in CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.io.*;

class Data implements Serializable {
  private int i;
  Data(int x) { i = x; }
  public String toString() {
    return Integer.toString(i);
  }
}

public class Worm implements Serializable {
  static Test monitor = new Test();
  // Generate a random int value:
  private static int r() {
    return (int)(Math.random() * 10);
  }
  private Data[] d = {
    new Data(r()), new Data(r()), new Data(r())
  };
  private Worm next;
  private char c;
  // Value of i == number of segments
  Worm(int i, char x) {
    System.out.println(" Worm constructor: " + i);
    c = x;
    if(--i > 0)
      next = new Worm(i, (char)(x + 1));
  }
  Worm() {
    System.out.println("Default constructor");
  }
  public String toString() {
    String s = ":" + c + "(";
    for(int i = 0; i < d.length; i++)
      s += d[i].toString();
    s += ")";
    if(next != null)
      s += next.toString();
    return s;
  }
  // Throw exceptions to console:
  public static void main(String[] args)
  throws ClassNotFoundException, IOException {
    Worm w = new Worm(6, 'a');
    System.out.println("w = " + w);
    ObjectOutputStream out =
      new ObjectOutputStream(
        new FileOutputStream("worm.out"));
    out.writeObject("Worm storage");
    out.writeObject(w);
    out.close(); // Also flushes output
    ObjectInputStream in =
      new ObjectInputStream(
        new FileInputStream("worm.out"));
    String s = (String)in.readObject();
    Worm w2 = (Worm)in.readObject();
    System.out.println(s + ", w2 = " + w2);
    ByteArrayOutputStream bout =
      new ByteArrayOutputStream();
    ObjectOutputStream out2 =
      new ObjectOutputStream(bout);
    out2.writeObject("Worm storage");
    out2.writeObject(w);
    out2.flush();
    ObjectInputStream in2 =
      new ObjectInputStream(
        new ByteArrayInputStream(
          bout.toByteArray()));
    s = (String)in2.readObject();
    Worm w3 = (Worm)in2.readObject();
    System.out.println(s + ", w3 = " + w3);
    monitor.expect(new Object[] {
      " Worm constructor: 6",
      " Worm constructor: 5",
      " Worm constructor: 4",
      " Worm constructor: 3",
      " Worm constructor: 2",
      " Worm constructor: 1",
      "%%w = :a\\(\\d+\\)" +
        ":b\\(\\d+\\):c\\(\\d+\\):d\\(\\d+\\)" +
        ":e\\(\\d+\\):f\\(\\d+\\)",
      "%%Worm storage, w\\d = " +
        ":a\\(\\d+\\):b\\(\\d+\\):c\\(\\d+\\)" +
        ":d\\(\\d+\\):e\\(\\d+\\):f\\(\\d+\\)",
      "%%Worm storage, w\\d = " +
        ":a\\(\\d+\\):b\\(\\d+\\):c\\(\\d+\\)" +
        ":d\\(\\d+\\):e\\(\\d+\\):f\\(\\d+\\)"
    });
  }
} ///:~
