//: c11:GZIPcompress.java
// {Args: GZIPcompress.java}
// From 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. See copyright notice in CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.io.*;
import java.util.zip.*;

public class GZIPcompress {
  static Test monitor = new Test();
  static final String usage =
    "Usage: \n" +
    "GZIPcompress file\n" +
    "\tUses GZIP compression to compress " +
    "the file to test.gz";

  // Throw exceptions to console:
  public static void main(String[] args)
  throws IOException {
    if(args.length == 0){
      System.out.println(usage);
      System.exit(1);
    }
    BufferedReader in =
      new BufferedReader(
        new FileReader(args[0]));
    BufferedOutputStream out =
      new BufferedOutputStream(
        new GZIPOutputStream(
          new FileOutputStream("test.gz")));
    System.out.println("Writing file");
    int c;
    while((c = in.read()) != -1)
      out.write(c);
    in.close();
    out.close();
    System.out.println("Reading file");
    BufferedReader in2 =
      new BufferedReader(
        new InputStreamReader(
          new GZIPInputStream(
            new FileInputStream("test.gz"))));
    String s;
    while((s = in2.readLine()) != null)
      System.out.println(s);
    monitor.expect(new String[] {
      "Writing file",
      "Reading file"},
      args[0]);
  }
} ///:~
