//: c09:SimpleHashMap.java
// A demonstration hashed Map.
// From 'Thinking in Java, 3rd ed.' (c) Bruce Eckel 2002
// www.BruceEckel.com. See copyright notice in CopyRight.txt.
import com.bruceeckel.simpletest.*;
import java.util.*;
import com.bruceeckel.util.*;

public class SimpleHashMap extends AbstractMap {
  static Test monitor = new Test();
  // Choose a prime number for the hash table
  // size, to achieve a uniform distribution:
  private final static int SZ = 997;
  private LinkedList[] bucket= new LinkedList[SZ];
  public Object put(Object key, Object value) {
    Object result = null;
    int index = key.hashCode() % SZ;
    if(index < 0) index = -index;
    if(bucket[index] == null)
      bucket[index] = new LinkedList();
    LinkedList pairs = bucket[index];
    MPair pair = new MPair(key, value);
    ListIterator it = pairs.listIterator();
    boolean found = false;
    while(it.hasNext()) {
      Object iPair = it.next();
      if(iPair.equals(pair)) {
        result = ((MPair)iPair).getValue();
        it.set(pair); // Replace old with new
        found = true;
        break;
      }
    }
    if(!found)
      bucket[index].add(pair);
    return result;
  }
  public Object get(Object key) {
    int index = key.hashCode() % SZ;
    if(index < 0) index = -index;
    if(bucket[index] == null) return null;
    LinkedList pairs = bucket[index];
    MPair match = new MPair(key, null);
    ListIterator it = pairs.listIterator();
    while(it.hasNext()) {
      Object iPair = it.next();
      if(iPair.equals(match))
        return ((MPair)iPair).getValue();
    }
    return null;
  }
  public Set entrySet() {
    Set entries = new HashSet();
    for(int i = 0; i < bucket.length; i++) {
      if(bucket[i] == null) continue;
      Iterator it = bucket[i].iterator();
      while(it.hasNext())
        entries.add(it.next());
    }
    return entries;
  }
  public static void main(String[] args) {
    SimpleHashMap m = new SimpleHashMap();
    Collections2.fill(m,
      Collections2.geography, 25);
    System.out.println(m);
    monitor.expect(new Object[] {
      "%%\\{((ERITREA=Asmara|CAPE "
        + "VERDE=Praia|GABON=Libreville|BENIN=Porto-Novo|"
        + "THE GAMBIA=Banjul|ETHIOPIA=Addis Ababa|"
        + "EGYPT=Cairo|CHAD=N'djamena|GUINEA=-|"
        + "DJIBOUTI=Dijibouti|CETE D'IVOIR \\(IVORY "
        + "COAST\\)=Yamoussoukro|KENYA=Nairobi|CENTRAL"
        + " AFRICAN REPUBLIC=Bangui|ALGERIA=Algiers|"
        + "CAMEROON=Yaounde|BURKINA FASO=Ouagadougou|"
        + "EQUATORIAL GUINEA=Malabo|GHANA=Accra|"
        + "COMOROS=Moroni|BISSAU=Bissau|BURUNDI=Bujumbura|"
        + "CONGO=Brazzaville|ANGOLA=Luanda|"
        + "BOTSWANA=Gaberone)(, ){0,1}){24}\\}"
    });
    }
} ///:~
