# Tama ohjelma on tarkoitettu vain debuggerin
# kayton harjoittelemiseen.
#
# Koodin lukmiseen ei kannata uhrata kohtuuttomasti aikaa,
# se on tarkoituksellisesti tehty olemaan vaikeasti
# luettava. Koodin lukemisen sijaan on tarkoitus
# kayttaa debuggeria
#
# Mielenkiinnon tyydyttamiseksi: koodi laskee 
# IP-headerin tarkistussumman

def oca(x,y):
    t = x + y
    c = t >> 16
    t += c
    t &= 0x0000FFFF
    return t 

def dwfy(x):
    r = []
    t = "0x"
    for i in range(0,len(x)):
        t += x[i]
        if i % 8 == 7:
            r.append(t)
            t = "0x"
    return r
        
def wfy(x):
    r = []
    y = int(x,16)
    r.append((y & 0xFFFF0000) >> 16)
    r.append((y & 0x0000FFFF))
    return r

def ics(x):
    y = dwfy(x)
    l = (int(y[0],16) & 0x0F000000) >> 24
    s = 0
    for i in range(0,l):
        z = wfy(y[i])
        s = oca(s,z[0])
        s = oca(s,z[1])
    s = ~s
    s &= 0xFFFF
    return s

H1 = "4f00007ca2020000fd01b0d582e9e215\
82e9236707271082e9e10ec01a6b0182\
e923fe0400201be000210bc0003846dc\
00215dbe000003ed00367100"
H2 = "45000050aa5a00001b06000082e9f42082e92391"
H3 = "450000339ec800001e06000082e9225482e9f423"
H4 = "460000ef7d21000020060000c0a80006c0a80010"

def main():
    print "First chsum: %#x" % (ics(H1))
    print "Second chsum: %#x" % (ics(H2))
    print "Third chsum: %#x" % (ics(H3))
    print "Fourth chsum: %#x" % (ics(H4))
    
if __name__ == "__main__":
    main()
